/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.IFormatterNode;
import java.util.List;

public class FormatterJSGroupNode
extends FormatterBlockWithBeginEndNode {
    private boolean hasCommentBefore;

    public FormatterJSGroupNode(IFormatterDocument document, boolean hasCommentBefore) {
        super(document);
        this.hasCommentBefore = hasCommentBefore;
    }

    protected void acceptBody(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        int spacesBeforeBody;
        IFormatterNode firstNode;
        List groupBody = this.getBody();
        boolean indentFixed = false;
        if (groupBody != null && !groupBody.isEmpty() && (firstNode = (IFormatterNode)groupBody.get(0)).shouldConsumePreviousWhiteSpaces()) {
            context.decIndent();
            indentFixed = true;
        }
        if ((spacesBeforeBody = this.getSpacesBeforeBody()) > 0) {
            this.writeSpaces(visitor, context, spacesBeforeBody);
        }
        super.acceptBody(context, visitor);
        int spacesAfterBody = this.getSpacesAfterBody();
        if (spacesAfterBody > 0) {
            this.writeSpaces(visitor, context, spacesAfterBody);
        }
        if (indentFixed) {
            context.incIndent();
        }
    }

    private int getSpacesBeforeBody() {
        return this.getInt("js.formatter.spaces.after.parentheses");
    }

    private int getSpacesAfterBody() {
        return this.getInt("js.formatter.spaces.before.parentheses.closing");
    }

    public int getSpacesCountBefore() {
        return this.getInt("js.formatter.spaces.before.parentheses");
    }

    protected boolean isIndenting() {
        return this.getDocument().getBoolean("js.formatter.indent.group.body");
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        return !this.hasCommentBefore;
    }
}

